import Mapper

# TAGS INDICATE IDENTIAL SHEETS
# NUMBERS are completely unconstrained
# LETTERS enforce internal symmetry
# < indicates a tile, with the arrow pointed in direction of polarization and feed
# X indicates an empty gap
# || or = (double lines) imply mirror symmetry on either side

#  |--------------------------------------------|
#  |  < |  1 |  < |  2 |  < |  3 |  < |  4 |  < |
#  |--------------------------------------------|
#  |  5 |  X |  6 |  X |  7 |  X |  8 |  X |  9 |
#  |--------------------------------------------|
#  |  < | 10 |  < | 11 |  < | 12 |  < | 13 |  < |
#  |--------------------------------------------|
#  | 14 |  X | 15 |  X | 16 |  X | 17 |  X | 18 |
#  |--------------------------------------------|
#  |  < | 19 |  < | 20 |  < | 21 |  < | 22 |  < |
#  |--------------------------------------------|
#  | 23 |  X | 24 |  X | 25 |  X | 26 |  X | 27 |
#  |--------------------------------------------|
#  |  < | 28 |  < | 29 |  < | 30 |  < | 31 |  < |
#  |--------------------------------------------|
#  | 32 |  X | 33 |  X | 34 |  X | 35 |  X | 36 |
#  |--------------------------------------------|
#  |  < | 37 |  < | 38 |  < | 39 |  < | 40 |  < |
#  |--------------------------------------------|

#           Each switch is independent
#              TOTAL NUMBER OF BITS = 960

# maps the switch states so each switch is unique
# bit ordeer is left to right, top to bottom by switch and then by sheet
class IndependentSwitches(Mapper.Mapper):
    # intializes the mapper
    # index map is a dictionary
    # return type: self
    def __init__(self):
        indexMap = {}
        bit_idx = 0
        # assign each switch new bits
        for sheet_y in range(4,-5,-1):
            for sheet_x in range(-4,5,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-4,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = bit_idx
                                bit_idx += 1
        # assign unused sheets to same bit (BIT 0)
        for sheet_y in [-5]:
            for sheet_x in range(-4,6):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_x in range(-3,4,1):
                        for switch_y in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = 0
        for sheet_y in range(-4,6):
            for sheet_x in [-5]:
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_x in range(-3,4,1):
                        for switch_y in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = 0
        super(IndependentSwitches,self).__init__(960,indexMap)
